﻿<?php
	include_once('header.php');
	if(!$user_home->is_logged_in()) {
		$user_home->redirect('login.php');
	}
	$versionsList = [];
	
	if ($stmt = $user_home->runQuery("SELECT * FROM versions")) {
		while ($row = $stmt->fetch_array(MYSQLI_ASSOC)) {
			$versionsList[] = $row;
		}
	}
?>
	<div id="message" style="display:none;">
		<div class="" id="alert">
			
		</div>
	</div>
      <div class="row">
			<div class="col-12">
				<div class="widget widget-table">
					<div class="widget-header"> <i class="icon-cloud-download"></i>
						<h3> <?= $lang['versions']; ?></h3>
						<a href="addversion.php" class="btn btn-danger btn-sm"><i class="icon-plus-sign"></i> <?= $lang['add_version']; ?></a>
					</div>
					<div class="widget-content">
						<table class="table table-bordered table-striped table-hover"  id="paginated">
							<thead class="thead-inverse">
								<tr>
									<th><?= $lang['id']; ?></th>
                                    <th><?= $lang['update_title']; ?></th>
                                    <th><?= $lang['version_force']; ?></th>
                                    <th><?= $lang['version_link']; ?></th>
                                    <th><?= $lang['version_message']; ?></th>
                                    <th><?= $lang['version_changes']; ?></th>
									<th class="td-actions" width="20%"> </th>
								</tr>
							</thead>
							<tbody>
							<?php if(count($versionsList)==0) {
								echo '<tr><td colspan="7"><div class="alert alert-danger">'.$lang["no_project"].'</div></td></tr>';
							} ?>
                  <?php foreach ($versionsList as $version) : ?>
							<tr id="row<?= $version['id']; ?>">
								<td style="font-size: 15px;"><?= $version['id']; ?></td>
                                <td style="font-size: 15px;" id="title<?= $version['id']; ?>"><?= $version['title']; ?></td>
                                <td style="font-size: 15px;" id="force<?= $version['id']; ?>"><?php echo ($version['is_force'] == 1 ? $lang['yes'] : $lang['no']); ?></td>
                                <td style="font-size: 15px; direction:ltr; text-align:center;" id="link<?= $version['id']; ?>"><?= $version['update_link']; ?></td>
                                <td style="font-size: 15px;" id="message<?= $version['id']; ?>"><?= $version['message']; ?></td>
								<?php
								$changes = $version['changes'];
								$changes_arr = explode(',', $changes);
								$changes_txt = '';
								foreach ($changes_arr as $change) {
									$changes_txt .= "$change <br>";
								}
								?>
                                <td style="font-size: 15px;" id="changes<?= $version['id']; ?>"><?= $changes_txt; ?></td>
								<td>
		<a href="editversion.php?id=<?= $version['id']; ?>" class="btn btn-warning btn-sm"><i class="fa icon-edit"></i>&nbsp;&nbsp;<?= $lang['edit']; ?></a>
		<a href="#" class="btn btn-danger btn-sm" id="deleteVersion<?= $version['id']; ?>"><i class="icon-trash"></i>&nbsp;&nbsp;<?= $lang['delete']; ?></a>
<script type="text/javascript">
	$('#deleteVersion<?= $version['id']; ?>').on("click", function () {
		$.confirm({
			title: "<?= $lang['delete']; ?> <?= $version['title']; ?>!",
			content: "<?= $lang['delete_question']; ?>",
			theme: 'bootstrap',
			buttons: {
				Yes: {
					text: "<?= $lang['yes']; ?>",
					btnClass: "btn-blue",
					keys: [
						"enter",
						"shift"
					],
					action: function () {
						delete_version("<?= $version['id']; ?>", "<?= $_SESSION['lang']; ?>");
					}
				},
				Cancel: {
					text: "<?= $lang['cancel']; ?>",
					action: function () {}
				}
			}
		});
	});
</script>
	</td>
	</tr>
	<?php endforeach; ?>
							</tbody>
						</table>
					</div>
				</div>
			</div>
	  </div>
<?php include_once('footer.php'); ?>